#ifndef _Defines_
#define _Defines_

char rev[6] ={1,1,1,0,0,0};


#define ESTOP_SW 16
#define STOP_SW  17
#define RUN_SW   18
#define EN_SW 	 19

#define SPINDLE_FWD 34
#define FAN      	35

#define pInput1	 20
#define pInput2	 21
#define pInput3	 22
#define pInput4	 23

#define X 0
#define Y 1
#define Z 2
#define A 3
#define B 4
#define C 5

// SPI
#define pSS   8
#define pMOSI 9
#define pMISO 10
#define pSCK  11

#define EN_DRV 	 24
#define pOutput_Enable 25

#define pX_SW 20
#define pY_SW 21
#define pZ_SW 22
#define pA_SW 23

#define pX_EncInx 54
#define pY_EncInx 55
#define pZ_EncInx 56
#define pA_EncInx 57

#define CHECK_SOFT_LIMT 1055

#define INIT_FLAG_BIT 63
#define Homing 61
#define OT_ENABLE 25
#define HomingStart 58
#define ACTIVE 60

#define StatusLed 35 //32 old, 35 new
#define CycleStart 18
#define CycleStartEnable 1054

#define XSPI 19 // Steps Per Inch
#define YSPI 20 // Steps Per Inch
#define ZSPI 21 // Steps Per Inch
#define ASPI 22 // Steps Per Inch
#define BSPI 23 // Steps Per Inch
#define CSPI 24 // Steps Per Inch
#define XSoftMin 25
#define XSoftMax 26
#define YSoftMin 27
#define YSoftMax 28
#define ZSoftMin 29
#define ZSoftMax 30
#define ASoftMin 31
#define ASoftMax 32
#define BSoftMin 33
#define BSoftMax 34
#define CSoftMin 35
#define CSoftMax 36

typedef void USERCALLBACK(void);
extern USERCALLBACK *UserCallBack;

int X_Mult;
int Y_Mult;
int Z_Mult;
int A_Mult;

int HomeSwitchArray[4] = {pX_SW,pY_SW,pZ_SW,pA_SW};
int EncInxArray[4] = {pX_EncInx,pY_EncInx,pZ_EncInx,pA_EncInx};

double time = 0.0;

int HasHomed = 0;

int taskSlice = 0;

char i;

#endif
